/* This file is Copyright 1998 Tom Rothamel. It's under the Gnu Public   *
 * license, see the file COPYING for details.                            */

#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include "in.h"


void guaranteed_read(int fd, char *buf, size_t count) {
	int bytes_read;

	if (count == 0) {
		return;
	}


	while(bytes_read = read(fd, buf, count)) {
		count -= bytes_read;
		buf += bytes_read;

		if (count == 0) {
			return;
		}
	}

	read_error("guaranteed_read failed.");
}

unsigned char readuc(int fd) {
	unsigned char uc;
	
	guaranteed_read(fd, &uc, sizeof(unsigned char));
	return uc;
}

char *readstring(int fd) {
	int len;
	char *buf;
	
	len = (int) readuc(fd);
	buf = malloc(len + 1);
	if(!buf) read_error("malloc of string failed.");
	guaranteed_read(fd, buf, len);
	buf[len] = 0;

	return buf;
}

