/* This file is Copyright 1998 Tom Rothamel. It's under the Gnu Public   *
 * license, see the file COPYING for details.                            */   

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "dm.h"
#include "greet.h"
#include "in.h"

#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>

extern char *egp;

void ReportError(char *e) {
	LogError("Greet: %s\n", e);
	exit(RESERVER_DISPLAY);
} 

void read_error(char *e) {
	ReportError(e);
}

greet_user_rtn GreetUser(
	struct display *d, Display ** dpy,
	struct verify_info *verify, struct greet_info *greet,
	struct dlfuncs *dlfuncs )
{
	int pid;
	int filedes[2];
	char *user;
	char *pass;
	int readloop;
	int i;
	

       	*dpy = XOpenDisplay(d->name);

	if (!d->grabServer)
		SetupDisplay (d);
	if (!*dpy) {
		LogError ("Cannot reopen display %s for greet window\n", d->name);
		exit (RESERVER_DISPLAY);
	}

	pipe(filedes);

	pid = fork();

	if (pid == -1) {
		/* Error forking */
		ReportError("Can't fork xlogin process.");
		exit(0);
	}

	if (pid == 0) {
		/* Child */
		char **env = 0;
		env = (char **) systemEnv(d, (char *)0, (char *)0);
		
      		close(filedes[0]);

		dup2(filedes[1], 3);   
		fcntl(3, F_SETFD, 0); /* Unset close-on-exec (Just in case) */

		execle(egp, egp, NULL, env);

		ReportError("Can't exec egp command.");
		exit(0);
	}			


	/* Parent */
	
	close(filedes[1]);

	while(1) {

       		user = readstring(filedes[0]);        /* String: username */
		pass = readstring(filedes[0]);        /* String: password */

		readloop = 1;
		while (readloop) {
			switch(readuc(filedes[0])){   /* Uc: Extension # */
			case 0:
				readloop = 0;
				break;

			case 1:
				/* Extension #1: A String with arguments for
				   Xsession. */

				if (greet->string) free(greet->string);
				greet->string = readstring(filedes[0]);
				break;

			default:
				ReportError("Unknown egp extension,");
			}
		}
		
		greet->name = user;                      
		greet->password = pass;                 
		
		if (Verify(d, greet, verify)) {
			kill(pid, SIGTERM);
			break;   
		}

		free(user);
	        free(pass);		

		if (greet->string) free(greet->string);
		greet->string = NULL;

		kill(pid, SIGUSR1);
	}


	DeleteXloginResources (d, *dpy);
    
	if (source (verify->systemEnviron, d->startup) != 0)
	{
		Debug ("Startup program %s exited with non-zero status\n",
		       d->startup);
		SessionExit (d, OBEYSESS_DISPLAY, FALSE);
	}

	return Greet_Success;
}
