/*
 * Copyright: (C) 1998 Daniel Berrange
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "slogin.h"
#include <shark/io/TextOutputStream.h>
#include <shark/lang/CommandLineException.h>


TLoginPromptApp slogin;


TLoginPromptApp::TLoginPromptApp(void)
: TAwtApplication("LoginPrompt")
{
}


void TLoginPromptApp::parseCommandLine(TList &args)
{
  TAwtApplication::parseCommandLine(args);
  
  TEnumeration &e = args.getElements();
  while (e.hasMoreElements())
  {
    TString &arg = (TString &)e.getNextElement();
    
    throw TCommandLineException(arg);
    
    args.remove(arg);
    delete &arg;
  }
  delete &e;
}


eint TLoginPromptApp::run(void)
{
  frame.setVisible(true);
  
  return TAwtApplication::run();
}


// End Of File
