/*
 * Copyright: (C) 1998 Daniel Berrange
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __DPB_LoginFrame_H__
#define __DPB_LoginFrame_H__

#include <shark/awt/Frame.h>
#include <shark/awt/Label.h>
#include <shark/awt/TextField.h>
#include <shark/awt/PushButton.h>
#include <shark/awt/Picture.h>


class TLoginFrame: public TFrame, public TActionListener, public TMouseListener
{
 public:
  TLoginFrame(void);
  virtual ~TLoginFrame(void);
  
 protected:
  TLabel welcomeLbl;
  TLabel userLbl;
  TLabel passLbl;
  TTextField usercode;
  TTextField password;
  TPushButton login;
  TPushButton reset;
  TPicture picture;
  TImage logo;

  virtual void mousePressed(TMouseEvent &e) {}
  virtual void mouseReleased(TMouseEvent &e) {}
  virtual void mouseClicked(TMouseEvent &e);
  virtual void mouseEntered(TMouseEvent &e) {}
  virtual void mouseExited(TMouseEvent &e) {}
  virtual void mouseMoved(TMouseEvent &e) {}

  virtual void actionPerformed(TActionEvent &e);
  virtual void processComponentEvent(TComponentEvent &e);
  virtual void processWindowEvent(TWindowEvent &e);
  virtual void warning(const TString &msg);
 private:
};


#endif __DPB_LoginFrame_H__

