/*
 * Copyright: (C) 1998 Daniel Berrange
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "slogin.h"
#include "logo.xpm"
#include <shark/lang/Application.h>
#include <shark/awt/extra/MessageDialog.h>
#include <shark/io/TextOutputStream.h>
#include <shark/awt/Toolkit.h>

#include <signal.h>

TLoginFrame *t;

void SignalUsr1(int ignored)
{
  TMessageDialog mb(*t, "Login", "Login Failed", TMessageDialog::Ok | TMessageDialog::Stop);
  mb.setVisible(true);

  signal(SIGUSR1, SignalUsr1);
}


void SignalTerm(int ignored)
{
  slogin.exit(0);
}


TLoginFrame::TLoginFrame(void)
: TFrame("Desktop Login", "Login"), 
welcomeLbl(slogin.getHostName(), TLabel::LEFT, TLabel::MIDDLE),
userLbl("Usercode:", TLabel::RIGHT, TLabel::MIDDLE), 
passLbl("Password:", TLabel::RIGHT, TLabel::MIDDLE),
login("Login"), reset("Reset")
{
  login.setDefault(true);
  
  t = this;
  add(welcomeLbl);
  add(userLbl);
  add(passLbl);
  add(usercode);
  add(password);
  add(login);
  add(reset);
  add(picture);
  
  login.addActionListener(self);
  reset.addActionListener(self);
  
  TFont f("courier", 34, 0);
  welcomeLbl.setFont(f);
  
  welcomeLbl.setBounds(60, 1, 298, 48);
  
  userLbl.setBounds(10, 60, 70, 30);
  usercode.setBounds(80, 60, 220, 30);
  
  passLbl.setBounds(10, 110, 70, 30);
  password.setBounds(80, 110, 220, 30);
  password.setEcho(false);
  
  login.setBounds(45, 155, 100, 30);
  reset.setBounds(175, 155, 100, 30);
  picture.setBounds(5, 5, 48, 48);

  setSize(58, 58);
  setLocation(0,0);

  TCursor cur(TCursor::HAND);
  setCursor(cur);

  picture.addMouseListener(self);
  
  signal(SIGUSR1, SignalUsr1);
  signal(SIGTERM, SignalTerm);
  signal(SIGINT, SignalTerm);
  signal(SIGPIPE, SIG_DFL);
}



TLoginFrame::~TLoginFrame(void)
{
}


void TLoginFrame::mouseClicked(TMouseEvent &e)
{
  if (getSize().width == 58) 
  {
    TRectangle rect = TToolkit::getToolkit().getDesktop().getBounds();
    setSize(320, 200);
    setLocation((rect.size.width / 2) - 160, (rect.size.height / 2) - 100);
  }
  else
  {
    setSize(58, 58);
    setLocation(0,0);
  }
}


void TLoginFrame::actionPerformed(TActionEvent &e)
{
  if (&e.getSource() == &reset)
  {
    usercode.setText("");
    password.setText("");
    usercode.requestFocus();
  }
  else if (&e.getSource() == &login)
  {
    TString uc = usercode.getText();
    TString pw = password.getText();
 
    unsigned char c = uc.getLength();
    char *d = uc.getString();
    write(3, &c, sizeof(unsigned char));
    write(3, d, c);
    c = pw.getLength();
    d = pw.getString();
    write(3, &c, sizeof(unsigned char));
    write(3, d, c);
    c = 0;
    write(3, &c, sizeof(unsigned char));
  }
}


void TLoginFrame::processComponentEvent(TComponentEvent &e)
{
  TFrame::processComponentEvent(e);

  if (e.getId() == TComponentEvent::COMPONENT_SHOWN)
  {
    TWindowEvent ev(self, TWindowEvent::WINDOW_ACTIVATED);
    processEvent(ev);
  }
  else if (e.getId() == TComponentEvent::COMPONENT_LOADED)
  {
    logo = TImage::loadXpm(logo_xpm);
    picture.setImage(logo);
  }
}


void TLoginFrame::processWindowEvent(TWindowEvent &e)
{
  TFrame::processWindowEvent(e);
  
  if (e.getId() == TWindowEvent::WINDOW_CLOSING)
    slogin.exit(0);
}


void TLoginFrame::warning(const TString &msg)
{
  TMessageDialog mb(self, "Login", msg, TMessageDialog::Ok | TMessageDialog::Stop);
  mb.setVisible(true);
}


// End of File

